const express = require("express");
const router = express.Router();

// Assuming you are using a pool connection
const db = require("../db"); // adjust path as needed

// GET /api/employees_details/details
router.get("/employees_details", async (req, res) => {
  try {
    // Use the employee_project_view which already has ORDER BY employee_id
    const query = "SELECT * FROM employee_project_view ORDER BY employee_id;";
    const [results] = await db.execute(query);

    res.status(200).json(results);
  } catch (err) {
    console.error("Error fetching employee details:", err);
    res.status(500).json({ error: "Internal Server Error" });
  }
});

module.exports = router;
