import React from 'react';
import { useTheme } from '../../contexts/ThemeContext';

const ActivityItem = ({ activity }) => {
  const { isLight } = useTheme();

  const headingClass = isLight 
    ? 'text-amber-800' 
    : 'text-gray-100';
  
  const textClass = isLight 
    ? 'text-amber-700' 
    : 'text-gray-300';

  return (
    <div 
      className={`flex items-start gap-4 p-4 rounded-lg transition-all duration-200 ${
        isLight ? 'hover:bg-yellow-50' : 'hover:bg-gray-700'
      }`}
    >
      <div className={`p-2 rounded-full flex items-center justify-center ${
        activity.type === 'success' 
          ? isLight ? 'bg-green-100' : 'bg-green-900' 
          : isLight ? 'bg-yellow-100' : 'bg-yellow-900'
      }`}>
        <div className={`${
          activity.type === 'success' ? 'text-green-600' : 'text-yellow-600'
        } text-lg flex-shrink-0`}>
          {activity.icon}
        </div>
      </div>
      <div className="flex-1">
        <h3 className={`font-semibold ${headingClass} mb-1`}>
          {activity.title}
        </h3>
        <p className={`${textClass} text-sm mb-2`}>
          {activity.description}
        </p>
        <span className={`text-xs ${isLight ? 'text-gray-500' : 'text-gray-400'}`}>
          {activity.time}
        </span>
      </div>
    </div>
  );
};

export default ActivityItem; 