import React from 'react';
import { FaUsers } from 'react-icons/fa';

const ErrorState = ({ error }) => {
  return (
    <div className="bg-red-100 border border-red-400 text-red-700 px-4 py-3 sm:px-6 sm:py-4 rounded-xl">
      <div className="flex items-center">
        <FaUsers className="mr-3 text-base sm:text-lg flex-shrink-0" />
        <span className="text-sm sm:text-base break-words">Error loading employees: {error}</span>
      </div>
    </div>
  );
};

export default ErrorState; 