import React from 'react';
import { 
  FaInfoCircle,
  FaCodeBranch
} from 'react-icons/fa';

const ActivityIcon = ({ type }) => {
  const getActivityIcon = (type) => {
    switch (type) {
      case 'assignment':
        return <FaInfoCircle className="text-blue-500 flex-shrink-0" />;
      default:
        return <FaCodeBranch className="text-gray-500 flex-shrink-0" />;
    }
  };

  return (
    <div className="flex items-center justify-center w-8 h-8">
      {getActivityIcon(type)}
    </div>
  );
};

export default ActivityIcon; 